/**
 * Beschrijft een werknemer.
 * 
 * @author Dominiek Vandewalle
 * @version 2016-05-20
 */
public class Werknemer
{
    //velden

    /**
     * Constructor voor objecten van de klasse Werknemer.
     * @param   naam    De naam van de werknemer.
     */
    public Werknemer(String naam)
    {
        this.naam = naam;
        aantalVerlofDagen = 20;
        ancienniteit = 0;
        maandloon = 1521.58;
    }
    
    /**
     * Geeft de naam van de werknemer terug.
     * @return  De naam van de werknemer.
     */
    public String getNaam()
    {
        return naam;
    }
    
    /**
     * Berekent het aantal verlofdagen van de werknemer.
     * @return Het aantal verlofdagen van de werknemer.
     */
    public int berekenAantalVerlofDagen()
    {
        return aantalVerlofDagen + ancienniteit;
    }
    
    /**
     * Verhoogt de anciënniteit van de werknemer met één.
     */
    public void verhoogAncienniteit()
    {
        ancienniteit++;
    }
    
    /**
     * Berekent het maandloon van de werknemer.
     * @return  Het maandloon van de werknemer.
     */
    public double berekenMaandloon()
    {
        return maandloon * (1 + ancienniteit / 100.0);
    }
}
